from pathlib import Path
import json

src_root = Path(r"C:\temp\bigquery\raw_snapshots")
dst_root = Path(r"C:\temp\bigquery\raw_snapshots_nd_flat")

dst_root.mkdir(parents=True, exist_ok=True)

for path in src_root.rglob("*.json"):
    rel_parts = path.relative_to(src_root).parts
    folder_name = rel_parts[0]
    orig_filename = rel_parts[-1]

    # Prefixed filename: 20250720_ladders-eu-266354.json
    new_filename = f"{folder_name}_{orig_filename}"

    out_path = dst_root / new_filename

    # Read pretty JSON → load to Python object
    with path.open("r", encoding="utf-8") as f:
        obj = json.load(f)

    # Write NDJSON (one JSON object per line)
    with out_path.open("w", encoding="utf-8") as f:
        json.dump(obj, f, separators=(",", ":"))
        f.write("\n")
